#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2000 by Forrest W. Young
 | For further information contact the author 
 | forrest@unc.edu or http://forrest.psych.unc.edu
 |
 | This file creates paths for the vista workspace file
 | This code was developed during 1999-2000.
 |___________________________________________________________________ 
 |#

(defun run-excel ()
  (set-working-directory (strcat *default-path* "startup" separator))
  (let* ((helper.exe *excel.exe*)
         (name.exe "EXCEL.EXE")
         (command-string 
          (strcat "\"" (get-working-directory) separator "excelvista.xls\""))
         )
    (when (not (system (strcat helper.exe " " command-string)))
          (setf helper.exe 
                (strcat *prgfil-path* "Microsoft Office\\Office\\excel.exe"))
          (when (not (system (strcat helper.exe " " command-string)))
                (one-button-dialog 
                 (strcat "Please Use the next Dialog to Locate " 
                         (string-upcase name.exe)))
                (set-working-directory *prgfil-path*)
                (setf helper.exe (open-file-dialog helper.exe ".exe"))
                (system (strcat "\"" helper.exe " " command-string "\""))))
    (setf *excel.exe* helper.exe)
    helper.exe ))
#|
(defun run-exe (helper.exe name.exe &optional command-string)
  (when (not (system (strcat helper.exe " " command-string)))
        (one-button-dialog 
         (strcat "Please Use the next Dialog to Locate " 
                 (string-upcase name.exe)))
        (set-working-directory *prgfil-path*)
        (setf helper.exe (open-file-dialog helper.exe ".exe"))
        (system (strcat helper.exe " " command-string))
        (setf *excel.exe* helper.exe)
        helper.exe ))

(defun run-helper (helper name &optional run command)
"ARGS: HELPER NAME &OPTIONAL RUN COMMAND
Trys to run HELPER. If cannot, searches for it and may optionally open a dialog to ask the user to find HELPER, using NAME as the string presented to the user."
  (let* ((result (system (strcat helper command))))
    (unless result
            (cond 
              ((equal helper "excel.exe") (setf result (find-excel)))
              ((equal helper "winbrowser.exe") (setf result (find-win-browser)))
            (unless result
                    (one-button-dialog 
                     (strcat "Please Use the next Dialog to Locate " 
                             (string-upcase name)))
                    (setf result (open-file-dialog helper ".exe"))
                    (when (and run result) (system (strcat helper " " command)))
                    result)))))

; original version
(defun try-to-find-win-browser ()
  (let* ((netscape-dir    "C:\\Program Files\\Netscape\\Communicator\\Program")
         (iexplore-dir    "C:\\Program Files\\Internet Explorer")
         (iexplore-dir-nt "C:\\Program Files\\Plus!\\Microsoft Internet"))
    (cond 
      ((set-working-directory netscape-dir)
       (setf *browser* (strcat netscape-dir "\\netscape.exe")))
      ((set-working-directory iexplore-dir)
       (setf *browser* (strcat iexplore-dir "\\iexplore.exe")))
      ((set-working-directory iexplore-dir-nt)
       (setf *browser* (strcat iexplore-dir-nt "\\iexplore.exe"))))
      )))
|#

(defun try-to-find-win-browser ()
  (let* ((netscape 
          "C:\\Program Files\\Netscape\\Communicator\\Program\\netscape.exe")
         (iexplore    
          "C:\\Program Files\\Internet Explorer\\iexplore.exe")
         (iexplore-nt 
          "C:\\Program Files\\Plus\\Microsoft Internet\\iexplore.exe"))
    (cond
      ((probe-file netscape)    (setf *browser* netscape))
      ((probe-file iexplore)    (setf *browser* iexplore))
      ((probe-file iexplore-nt) (setf *browser* iexplore-nt))
      (t
       (one-button-dialog 
        "Please Use the Next Dialog to\nLocate Your Favorite Web Browser")
       (setf *browser* (open-file-dialog "Browser" ".exe"))))
    (setf *browser.exe* *browser*)
    ))

(setf *startup-path* nil)

(defun print-path-defaults (&optional verbose)
"Arg: (&optional verbose)
prints path defaults"
  (let ((str (strcat
              (format nil "~%; INI PATH DEFAULTS~%")
              (format nil "; *xlib-path-default*    ~a~%" *xlib-path-default*)
              (format nil "; *lib-path-default*     ~a~%" *lib-path-default* )
              (format nil "; *user-path-default*    ~a~%" *user-path-default* )
              (format nil "; *prefs-path-default*   ~a~%" *prefs-path-default* )
              (format nil "; *system-path-default*  ~a~%" *system-path-default* )
              (format nil "; *data-path-default*    ~a~%" *data-path-default*)
              (format nil "; *prgfil-path-default*  ~a~%" *prgfil-path-default* )
              (format nil "~%; DERIVED PATH DEFAULT~%")
              (format nil "; *default-path* ~a~%" *default-path* )
              )))
    (unless verbose (help-window str))
    str))

(defun set-path-defaults (&optional verbose) 
"Arg: (&optional verbose)
Binds path defaults to their ini values and makes vista paths. If VERBOSE prints path defaults. Use (make-default-ini) if ini path values are bad."
  (make-default-path-defaults )
  (define-vista-paths)
  (when verbose (print-path-defaults))
  t)

(defun get-path-defaults (&optional verbose)
"Arg: (&optional verbose)
Returns (and reports, if VERBOSE) path defaults"
  (when verbose (print-path-defaults))
  (get-ini-paths))

(defun fix-system-path ()
  (let ((test-dir)
        (pwd (get-working-directory)))
    
    (cond 
      ((and (boundp '*system-path*) *system-path* (> 4 (length *system-path*)))
       (setf test-dir (select *system-path* (iseq (- (length *system-path*) 1))))
       (setf test-dir 
             (cond
               ((set-working-directory test-dir) test-dir)
               ((set-working-directory "C:\\windows\\system32") 
                (setf *system-path* "C:\\windows\\system32\\"))
               ((set-working-directory "C:\\WINNT\\system32") 
                (setf *system-path* "C:\\WINNT\\system32\\"))
               (t nil))))
      (t
       (setf test-dir
             (cond
               ((set-working-directory "C:\\windows\\system32") 
                (setf *system-path* "C:\\windows\\system32\\"))
               ((set-working-directory "C:\\WINNT\\system32") 
                (setf *system-path* "C:\\WINNT\\system32\\"))
               (t nil)))))
    (cond
      (test-dir
       (strcat test-dir "\\")
       (setf *system-path-default* test-dir)
       (setf *system-path* test-dir))
      (t (one-button-dialog "bad system path" )))
    (set-working-directory pwd)
    *system-path*))


(defun fix-paths (&optional (user-defined-default-path nil))
"Arg:  (&optional (user-defined-default-path nil))
Modifies WSLW32.INI file and fixes all paths."
  (make-default-ini user-defined-default-path))

(defun make-default-ini (&optional (user-defined-default-path nil))
"makes the default ini values and then uses set-path-defaults to generate all vista paths. This is the main entry to the system to fix a bad paths."
  (unless user-defined-default-path 
    (message-dialog 
      (format nil "WARNING:~%Generating Default WXLS32.INI file and paths.")))
  (format t "~%; ~aGenerating Default WXLS32.INI file and paths.~%" (if user-defined-default-path "ViSta is " "WARNING: "))
  (unless user-defined-default-path
    (format t "; NOTE:    These paths depend on correctness of "))
  ;(setf *system-path*  *system-path-default*)
  (fix-system-path)
  (setf *default-path* 
        (cond
	  (user-defined-default-path 
           (setf *default-path-default* user-defined-default-path)) 
          ((and (boundp '*installation-startup-path*) *installation-startup-path*)
           (setf *default-path-default* *installation-startup-path*)
           (format t "*installation-startup-path* (the best alternative). The path is ~%~a~%" *installation-startup-path*)
           *default-path-default*)
           (*startup-path* 
            (setf *default-path-default* *startup-path*)
           (format t "*startup-path*. The path is ~%~a~%"
                      *default-path-default*)
           *default-path-default*)
          ((and (boundp '*default-path-default*) *default-path-default*)
           (format t "*default-path-default*. The path is ~%~a~%"
                      *default-path-default*)
           *default-path-default*)
          (t (setf *default-path-default* (strcat (get-working-directory) *separator*))
             (format t "using the current directory. The path is ~%; ~a~%" *default-path-default*)
             *default-path-default*)))

    (unless (probe-file (strcat *default-path* "ViSta.exe"))
       (let ((err)
             (str (format nil "error: *default-path* is ~a~%"*default-path*)))
          (when (not (equal #\\ (select (reverse *default-path*) 0)))
             (setf *default-path* (strcat *default-path* "\\" ))
             (cond 
               ((probe-file (strcat *default-path* "ViSta.exe"))
                (setf str (format nil "Error (Corrected)~%~a"
                                      (strcat str (format nil "fixed: *default-path is ~a~%" 
                                                   *default-path*))))
                (one-button-dialog str))
               (t (setf err t))))
          (setf str (format nil "Error (Catastrophic)~%~a"
                                 (strcat "*default-path* is " *default-path*)))
               (one-button-dialog str)
               (error str)))

  (setf *startup-path* *default-path*)
  (setf *xlib-path*    *default-path*)
  (setf *lib-path*     *default-path*)
  (setf *prefs-path*   (strcat *default-path* "prefs" *separator*))
  (setf *user-path*    "C:\\MyViSta\\")
  (setf *data-path*    (strcat *default-path* "data" *separator*))
  (setf *ini-file*     (strcat *default-path* "wxls32.ini"))
  (setf prefs-dir?     t)
  (setf user-dir?      t)
  (setf ini-exists?    t)
  (define-vista-paths)
  (make-default-path-defaults)
 ; (fix-system-path)
  (write-ini-paths)
  (print-ini-paths)
  (format t "~a" (print-path-defaults))
  t)
  
(defun DISPLAY-ini-paths ()
   (message-dialog (string-upcase (ini-paths-info))))

(defun print-ini-paths ()
   (format t "~a" (ini-paths-info)))

(defun ini-paths-info ()
    (let ((paths (get-ini-paths)))
      (strcat
             (format nil "WXLS43.INI                   ~a~%" *ini-file*)
             (format nil "Xlisp LibDir  *xlib-path*    ~a~%" (select paths 0))
             (format nil "ViSta LibDir  *lib-path*     ~a~%" (select paths 1))
             (format nil "ViSta UserDir *user-path*    ~a~%" (select paths 2))
             (format nil "ViSta PrefDir *prefs-path*   ~a~%" (select paths 3))
             (format nil "ViSta SysDir  *system-path*  ~a~%" (select paths 4))
             (format nil "ViSta ProgDir *data-path*    ~a~%" (select paths 5))
             (format nil "ViSta LibDir  *prgfil-path*  ~a~%" (select paths 6)))))

(defun get-ini-paths (&key (dir) (silent))
"Args: none
Gets original ini paths. The paths are output as a seven element list 
*xlib-path* *lib-path* *user-path* *prefs-path*  *system-path* *data-path* *prgfil-path*"
  (let* ((ini-file (msw-get-profile-string "ViSta" "LibDir"       *ini-file*)))
    (if (probe-file (strcat ini-file "wxls32.ini"))
        (list (msw-get-profile-string "XLisp"      "LibDir"       *ini-file*)
              (msw-get-profile-string "ViSta"      "LibDir"       *ini-file*)
              (msw-get-profile-string "ViSta"      "UserDir"      *ini-file*)
              (msw-get-profile-string "ViSta"      "PrefDir"      *ini-file*)
              (msw-get-profile-string "ViSta"      "SysDir"       *ini-file*)
              (msw-get-profile-string "ViSta"      "DataDir"      *ini-file*)
              (msw-get-profile-string "ViSta"      "ProgDir"      *ini-file*))
        nil)))

(defun write-ini-paths ()
  (msw-write-profile-string "XLisp"    "LibDir"    *xlib-path*    *ini-file*)
  (msw-write-profile-string "ViSta"    "LibDir"    *lib-path*     *ini-file*)
  (msw-write-profile-string "ViSta"    "SysDir"    *system-path*  *ini-file*)
  (msw-write-profile-string "ViSta"    "UserDir"   *user-path*    *ini-file*)
  (msw-write-profile-string "ViSta"    "PrefDir"   *prefs-path*   *ini-file*)
  (msw-write-profile-string "ViSta"    "DataDir"   *data-path*    *ini-file*)
  (msw-write-profile-string "ViSta"    "ProgDir"   *prgfil-path*  *ini-file*)
  )

(defun write-ini-defaults ()
  (msw-write-profile-string "ViSta"    "ViStaOp"   "No"           *ini-file*)
  (msw-write-profile-string "Listener" "Font"      "MonoType.Com" *ini-file*)
  (msw-write-profile-string "Listener" "FontSize"  "9"            *ini-file*)
  (msw-write-profile-string "Graphics" "Font"      "MonoType.Com" *ini-file*)
  (msw-write-profile-string "Graphics" "FontSize"  "9"            *ini-file*)
  (msw-write-profile-string "Printer"  "Font"      "MonoType.Com" *ini-file*)
  (msw-write-profile-string "Printer"  "FontSize"  "9"            *ini-file*)
  (msw-write-profile-string "XLisp"    "RecallMainFrame" "Yes"    *ini-file*)
  (msw-write-profile-string "XLisp"    "HideMainFrame"   "Yes"    *ini-file*)
  )


(defun print-path-defaults ()	(strcat
      	  (format nil "~%; PATH DEFAULTS~%")
              (format nil "; *startup-path*         ~a~%" *startup-path* )
              (format nil "; *default-path-default* ~a~%" *default-path-default* )
              (format nil "; *default-path*         ~a~%" *default-path* )
              (format nil "; *system-path-default*  ~a~%" *system-path-default* )
              (format nil "; *prgfil-path-default*  ~a~%" *prgfil-path-default* )
              )) 


        
(defun make-default-path-defaults ()
"sets default path defaults to the .ini entries. these paths are
*xlib-path* *lib-path* *user-path* *prefs-path*  *system-path* *data-path* *prgfil-path* *default-path*"
  (let* ((ini-defaults (get-ini-paths))
         (path-list (list *xlib-path-default* *lib-path-default* 
                          *user-path-default* *prefs-path-default*  
                          *system-path-default* *data-path-default* 
                          *prgfil-path-default* ))
         )
    (mapcar #'(lambda (path i)
                (setf path (select ini-defaults i)))
            path-list (iseq (length path-list)))
    (setf *default-path-default* *lib-path-default*)
    (setf *default-path* *lib-path-default*)))
    

(defun define-vista-paths ()
  (setf *default-path*           *lib-path*)
  (setf *genesys-path*           (strcat *default-path* "genesys\\"))
  (setf *working-dir*            *default-path*)
  (setf *default-dir*            *default-path*)
  (setf *working-path*           *default-path*)
  (setf *ini-path*               *default-path*)
  (setf *ini-file*    (strcat *default-path* "wxls32.ini"))
  (setf *xlib-path-default*      *xlib-path*)
  (setf *lib-path-default*       *lib-path*)
  (setf *ini-path-default*       *ini-path*)
  (setf *user-path-default*      *user-path*)
  (setf *prefs-path-default*     *prefs-path*)
  (setf *default-path-default*   *default-path*)
  (setf *system-path-default*    *system-path*)
  (setf *prefs-dir-name*         *prefs-path*)
  (setf *user-dir-name*          *user-path*)
  (setf prefs-dir? (if *prefs-path* t nil))
  (setf user-dir?  (if *user-path*  t nil))
  (setf *data-dir-name*          *data-path*)
  (setf *examples-data-dir-name* *data-path*)
  (setf *current-data-dir-name*  *data-path*)
  (setf *help-path*      (strcat *default-path* "help" *separator* "help" *separator* ))
  (setf *example-path*   (strcat *default-path* "help" *separator* "examples" *separator*))
  (setf *data-path-default*      (strcat *default-path* "data"     *separator*))
  (setf *runtime-path*           (strcat *default-path* "runtime"  *separator*))
  (setf *vista-dir-name*         (strcat *default-path* "runtime"  *separator*))
  (setf *runtime-dir-name*       (strcat *default-path* "runtime"  *separator*))
  (setf *code-dir-name*          (strcat *default-path* "fslfiles" *separator*))
  (setf *fsl-dir-name*           (strcat *default-path* "fslfiles" *separator*))
  (setf *fsl-path*               (strcat *default-path* "fslfiles" *separator*))
  (setf *base-dir-name*          (strcat *default-path* "source"   *separator*))
  (setf *source-dir-name*        (strcat *default-path* "source"   *separator*))
  (setf *source-path*            (strcat *default-path* "source"   *separator*))
  (setf *devel-dir-name*         (strcat *source-path*  "devloper" *separator*))
  (setf *devel-path*             (strcat *source-path*  "devloper" *separator*))
  (setf *distrib-dir-name*       (strcat *source-path*  "distrib"  *separator*))
  (setf *distrib-path*           (strcat *source-path*  "distrib " *separator*))
  (setf *examples-path*          *example-path*)
  (setf *example-dir-name*       *example-path*)
  (setf *examples-dir-name*      *example-path*)
  (setf *demos-dir-name*         *example-path*)
  (setf *demos-path*             *example-path*)
  (setf *plugin-dir-name*        (strcat *default-path* "plugins"  *separator*))
  (setf *plugins-dir-name*       (strcat *default-path* "plugins"  *separator*))
  (setf *plugins-path*           (strcat *default-path* "plugins"  *separator*))
  (setf *plugin-path*            (strcat *default-path* "plugins"  *separator*))
  (setf *plugins-directory*      (strcat *default-path* "plugins"))
  (setf *update-directory*       (strcat *default-path* "update"))
  (setf *update-path*            (strcat *default-path* "update"   *separator*))
  (setf *open-edit-here-directory*   (if *pro-version*  *default-path* *user-dir-name*))
  (setf *open-data-here-directory*       *data-dir-name*)
  (setf *open-import-here-directory*     *default-path*)
  (setf *help-dir-name*          (strcat *default-path* "help"     *separator* "help"     *separator*))
  (setf *help-path*              (strcat *default-path* "help"     *separator* "help"     *separator*))
  (setf *guide-path*             (strcat *default-path* "help"     *separator* "guidance" *separator*))
  (setf *guide-dir-name*         (strcat *default-path* "help"     *separator* "guidance" *separator*))
  (setf *vistart-path*           (strcat *default-path* "startup"  *separator* "vista"    *separator*))
 ) 


(defun show-data-types ()
  (format t    "~%Basic Data Type       ~a~%Extended Data Type    ~a~%Generalized Data Type ~a~%Apparent Data Type    ~a~%Frequency Data        ~a~%Array Data            ~a~%Matrix Data?          ~a~%Classification Data?  ~a~%Category Data?        ~a~%FreqClass Data?       ~a~%CrossTabs Data?       ~a~%missing data?         ~a~%"
(send $ :data-type)
(send $ :extended-data-type) 
(send $ :generalized-data-type) 
(send $ :determine-data-type) 
(send $ :freq) 
(send $ :array)
(send $ :matrix-data?)
(send $ :classification-data?)  
(send $ :category-data?) 
(send $ :freqclass-data?) 
(send $ :crosstabs-data?)
(send $ :missing-data?)))


(defun show-paths ()
  (print-paths))

(defun report-current-paths ()
  (print-paths))


(defun print-paths ()
	(help-window  (strcat (print-path-defaults)

  (format nil "~%; INI PATHS~%")
  (format nil "; *ini-file*         ~a~%" *ini-file*)
  (format nil "; *system-path*:     ~a~%" *system-path*)
  (format nil "; *prgfil-path*      ~a~%" *prgfil-path*)
  (format nil "; *xlib-path*:       ~a~%" *xlib-path*)
  (format nil "; *lib-path*:        ~a~%" *lib-path*)
  (format nil "; *prefs-path*:      ~a~%" *prefs-path*)
  (format nil "; *user-path*:       ~a~%" *user-path*)
  (format nil "; *data-path*        ~a~%" *data-path*)

  (format nil "~%; DERIVED PATHS~%")
  (format nil "; *default-path*:    ~a~%" *default-path*)
 ; (format nil "; *startup-path*     ~a~%" *startup-path*)
  (format nil "; *working-path*     ~a~%" *working-path* )
  (format nil "; *ini-path*         ~a~%" *ini-path* )
  (format nil "; *genesys-path*:    ~a~%" *genesys-path*)
  (format nil "; *fsl-path*         ~a~%" *fsl-path*)
  (format nil "; *runtime-path*     ~a~%" *runtime-path*)
  (format nil "; *source-path*      ~a~%" *source-path*)
  (format nil "; *devel-path*       ~a~%" *devel-path*)
  (format nil "; *examples-path*    ~a~%" *examples-path*)
  (format nil "; *demos-path*       ~a~%" *demos-path*)
  (format nil "; *help-path*        ~a~%" *help-path*)
  (format nil "; *guide-path*       ~a~%" *guide-path*)
  (format nil "; *vistart-path*     ~a~%" *vistart-path*)
  (format nil "; *plugins-path*     ~a~%" *plugins-path*)
  
  (format nil "~%; INITIAL VARIABLES~%")
  (format nil "; *initial-install*: ~a~%"*initial-install*)
  (format nil "; *pro-version*:     ~d~%"*pro-version*)
  (format nil "; prefs-dir?:        ~a~%"prefs-dir?)
  (format nil "; user-dir?:         ~a~%"user-dir?)
  (format nil "; ini-exists?:       ~a~%"ini-exists?)
  (format nil "; *run-number*:      ~d~%"*run-number*)
  (format nil "; *show-web-docs*    ~d~%"*show-web-docs*)
  (when *vista*
        (format nil "; show-first-help ~d~%" (send *vista* :show-first-help))
        (format nil "; show-welcome       ~d~%" (send *vista* :show-welcome)))
	)
           )
  )

